//%attributes = {"publishedSql":true}
// Method: _blob Position3
// $positionOfFirstOccurrence:=blobPosition($stringToSearchFor;ptrToBlobToSearch
//   {;caseSensitiveLongint{;startSearchingBlobAt{;stopSearchingBlobAt}}})
// 2003.02.13-17:31:24 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($0)  //$positionOfFirstOccurrence
C_POINTER:C301($1)  //ptr to blob
C_TEXT:C284($2)  // $searchString
C_LONGINT:C283($3)  // $caseSensitiveLongint  
C_LONGINT:C283($4)  //$startSearchingBlobAt
C_LONGINT:C283($5)  //$stopSearchingBlobAt

// A Boyer-Moore search that finds the first occurrence of $stringToSearchFor in
// ptrToBlob->.  Note that caseSensitiveLongint WILL differentiate diacriticals
// from their regular counterparts. 

// -------------------------------------------------------------------------------
//                               C H A N G E    H I S T O R Y
// -------------------------------------------------------------------------------
// 12/27/01 v. 1.01 Rob Laveaux 
// Implemented Delta2. The problem addressed arises when a character repeats in
// in the search pattern ($stringToSearchFor).  The original code did not check
// for a partial search when the shift was computed, resulting in some skipping
// past legitimate finds.  Now no skipping when a character repeats in the pattern
// will occur.  See the original paper by Boyer and Moore for more information on
// Delta2.
//
// 01/04/02 v. 1.1 Mike Kerner 
// Tweaked Rob's change to implement the (suggested) check on shift <1.  This is
// because one of the primary advantages of BM over some other algorithms is that
// there is never a backwards check.  As a result of Rob's Delta2 implementation
// there will be cases where a backwards skip will be computed, which increases
// the completion time, e.g. searching for "bob" in "this isbbob's last good day" 
// (the "isbbob's" is intentional).
// Also:
// a) Made case-sensitive optional
// b) Added optional start and stop search points in the blob
// c) Converted the search string to a blob so we don't have to keep extracting
//      ascii values from it
// d) Optimized other parts of the code
// e) Removed extraneous compiler directives
// f) Changed variable names to make them more descriptive
// g) Marked Rob's and my non-cosmetic changes in the code to make them easier
//     to spot.
// -------------------------------------------------------------------------------
//                           H A N D L E    P A R A M E T E R S
// -------------------------------------------------------------------------------
C_BOOLEAN:C305($done)
C_TEXT:C284($uppercase; $_str_ ToLower)
C_BLOB:C604($searchStringAsBlob1; $searchStringAsBlob2)
C_LONGINT:C283($caseSensitive; $startSearchingBlobAt; $stopSearchingBlobAt; $searchStringLength)
C_LONGINT:C283($i; $lineUpWithBlobAt; $index; $charInBlob; $shift; $searchPositionInBlob)

$caseSensitive:=kFalse
$startSearchingBlobAt:=0
$stopSearchingBlobAt:=BLOB size:C605($1->)-1

If (Count parameters:C259>=3)
	$caseSensitive:=$3
	If (Count parameters:C259>=4)
		$startSearchingBlobAt:=$4
		If ($startSearchingBlobAt<0)
			$startSearchingBlobAt:=0
		End if   //$startSearchingBlobAt<0      
		If (Count parameters:C259>=5)
			If ($5<$stopSearchingBlobAt)  // i.e. not after the last character in the blob
				$stopSearchingBlobAt:=$5
			End if   //($5<=blob size($1->)-1)
		End if   // cp>= 5
	End if   // cp >=4
End if   // cp>=3

// -------------------------------------------------------------------------------
//                                    S E T    U P    T A B L E
// -------------------------------------------------------------------------------
$0:=-1  // by default don't match anywhere
$searchStringLength:=Length:C16($2)  // used for repeating pattern match hueristic and to do away with checking the
// original search string.
$done:=False:C215
Case of 
	: ($searchStringLength=1)
		$uppercase:=_str_ ToUpper($2)
		TEXT TO BLOB:C554($uppercase; $searchStringAsBlob1; Mac text without length:K22:10)
		$_str_ ToLower:=_str_ ToLower($2)
		TEXT TO BLOB:C554($_str_ ToLower; $searchStringAsBlob2; Mac text without length:K22:10)
		
		For ($searchPositionInBlob; $startSearchingBlobAt; $stopSearchingBlobAt)
			$charInBlob:=$1->{$searchPositionInBlob}
			Case of 
				: (($charInBlob=$searchStringAsBlob1{$index}) | ($charInBlob=$searchStringAsBlob2{$index}))
					$0:=$searchPositionInBlob
					$searchPositionInBlob:=$stopSearchingBlobAt+1  //exit loop
			End case 
		End for 
	Else 
		If ((($stopSearchingBlobAt+1)-$startSearchingBlobAt)>=$searchStringLength)
			//  well, the search string fits in
			// length of the segment of the blob we're checking to find out if it's >  2*the
			// length of the string (b/c that's roughly the amount of work needed to
			// generate the shift table, but hey, that's why you're in here - refine the
			// code!  If you decide to not generate the table then I'd suggest going
			// with KMP or a straight brute-force search.
			If ($caseSensitive=kFalse)
				//  in this case we will have two separate blob representations to compare to,
				// $searchStringAsBlob1 which will be _str_ ToUpper and $searchStringAsBlob2
				// which will be _str_ ToLower
				$uppercase:=_str_ ToUpper($2)
				TEXT TO BLOB:C554($uppercase; $searchStringAsBlob1; Mac text without length:K22:10)
				$_str_ ToLower:=_str_ ToLower($2)
				TEXT TO BLOB:C554($_str_ ToLower; $searchStringAsBlob2; Mac text without length:K22:10)
			Else   // $caseSensitive
				// to make the code work we will still have two copies of the blob that are
				// identical.  This removes the need for the $caseSensitive code elsewhere
				// in the method, which is a net wash b/c we have to check $caseSensitive
				// anyway, so why not just check the blob twice and be done with it?  
				TEXT TO BLOB:C554($2; $searchStringAsBlob1; Mac text without length:K22:10)
				TEXT TO BLOB:C554($2; $searchStringAsBlob2; Mac text without length:K22:10)
			End if   //$caseSensitive
			
			ARRAY INTEGER:C220($shiftTable; 255)
			For ($i; 0; 255)  // populate the shift table
				$shiftTable{$i}:=$searchStringLength+1
			End for   //$i;0;255
			
			For ($i; 0; ($searchStringLength-1))  // walk the search string from left to right, assigning the
				// length of the string - the position of the character in the string into the
				// position of the array which equals the ascii value of the character.  Thus for
				//  CRAP the table would have values (in the associated positions) of 3 2 10
				// and for GOOD 3 1 0 b/c we assign "O" a 2 then a 1.  This is what is expected
				// for any string where the character repeats.  Thus for Bob we would have 10
				// The problem with the shift is taken into account later.
				
				$shiftTable{$searchStringAsBlob1{$i}}:=$searchStringLength-$i
				$shiftTable{$searchStringAsBlob2{$i}}:=$searchStringLength-$i
				// for case-sensitive operations.  For
				// non-case-sensitive, we're just wasting an assignment, which (hopefully) the
				// compiler will ignore.
			End for   //$i;1;$searchStringLength    
		Else   // oops - the blob isn't long enough to contain the string
			$done:=True:C214
		End if   // (($stopSearchingBlobAt-$startSearchingBlobAt)>$searchStringLength)
		
		// -------------------------------------------------------------------------------
		//                                 D O    T H E    S E A R C H
		// -------------------------------------------------------------------------------
		$index:=$searchStringLength-1
		$lineUpWithBlobAt:=$startSearchingBlobAt
		While (Not:C34($done))
			$searchPositionInBlob:=$lineUpWithBlobAt+$index
			Case of 
				: ($searchPositionInBlob>$stopSearchingBlobAt)
					// walked past the last search point in the blob, so we can't match
					$done:=True:C214
				: ($index<0)  // walked off the end of the string, so we're done
					$done:=True:C214
					$0:=($searchPositionInBlob+1)-$startSearchingBlobAt
					//b/c we just walked  back a position to check for a 
					// have one.      
				Else 
					If ($index%20000=0)
						IDLE:C311  //give 4D some time
					End if 
					$charInBlob:=$1->{$searchPositionInBlob}
					Case of 
						: (($charInBlob=$searchStringAsBlob1{$index}) | ($charInBlob=$searchStringAsBlob2{$index}))
							// then we have an exact match in the corresponding
							// position .  We do the double comparison b/c if not case sensitive then we have
							// _str_ ToUpper and _str_ ToLower versions of the search pattern as a blob.  For case
							// sensitive situations we do a double-comparison, but it saves us the extra
							// check against $caseSensitive anyway.
							$index:=$index-1
						Else   // no match in the current position
							$shift:=$shiftTable{Int:C8($1->{$searchPositionInBlob})}-($searchStringLength-$index)  // 
							//       
							If ($shift<0)
								$shift:=1
							End if   //$shift<0   
							//    
							$lineUpWithBlobAt:=$lineUpWithBlobAt+$shift
							$index:=$searchStringLength-1
					End case   //$searchPositionInString<0   
			End case   //done either way
		End while   //Not($done)
		
End case 
